import pygame
from text import Text

def title_page(screen, if_renew_music, stats):
	'''开始界面'''
	play_button = Text(600, 630, screen, "开始游戏", 60)
	help_button = Text(100, 670, screen, "帮助&设置")
	item_button = Text(1150, 670, screen, "收集")
	exit_button = Text(1150, 30, screen, "退出")
	title = pygame.image.load('images/title.png')
	title_rect = title.get_rect()
	title_rect.center = [600,130]
	title2 = pygame.image.load('images/title2.png')
	title2_rect = title.get_rect()
	title2_rect.center = [205,330]
	
	screen.fill((255,255,255))
	screen.blit(title2, title2_rect)
	screen.blit(title, title_rect)
	play_button.show_text()
	help_button.show_text()
	item_button.show_text()
	exit_button.show_text()
	pygame.display.flip()

	if if_renew_music and stats.if_play_music:
		pygame.mixer.music.load('audios/title.mp3')
		pygame.mixer.music.play(-1, 0)
	
	while True:
		for event in pygame.event.get():
			if event.type == pygame.QUIT:
				pygame.mixer.music.stop()
				return 0
			elif event.type == pygame.MOUSEBUTTONDOWN:
				pos = pygame.mouse.get_pos()
				if play_button.rect.collidepoint(pos):
					play_button.change_color(200,200,200)
					pygame.display.update()
					pygame.time.wait(200)
					pygame.mixer.music.stop()
					return 1
				elif help_button.rect.collidepoint(pos):
					help_button.change_color(200,200,200)
					pygame.display.update()
					pygame.time.wait(200)
					return 2
				elif item_button.rect.collidepoint(pos):
					item_button.change_color(200,200,200)
					pygame.display.update()
					pygame.time.wait(200)
					return 3
				elif exit_button.rect.collidepoint(pos):
					exit_button.change_color(200,200,200)
					pygame.display.update()
					pygame.time.wait(200)
					return 0
			if event.type == pygame.KEYDOWN:
				if event.key == pygame.K_c:
					press = True
				if event.key == pygame.K_r and press:
					pygame.mixer.music.stop()
					return -1
			if event.type == pygame.KEYUP:
				if event.key == pygame.K_c:
					press = False
