import pygame.font

class Text():
	'''文字类按钮'''
	
	def __init__(self, x, y, screen, msg, size = 32,
			bgcolor = (255,255,255), color = (0,0,0)):
		'''初始化按钮的属性'''
		self.screen = screen
		self.bgcolor = bgcolor
		self.color = color
		self.font = pygame.font.SysFont('SimHei', size)
		self.msg = msg
		self.image = self.font.render(msg, True, color, bgcolor)
		self.rect = self.image.get_rect()
		self.rect.center = [x,y]

	def show_text(self):
		'''绘制文本'''
		self.screen.blit(self.image, self.rect)

	def change_color(self, r, g, b):
		'''绘制变色文本'''
		self.color = (r, g, b)
		self.image = self.font.render(self.msg, True, self.color, self.bgcolor)
		self.screen.blit(self.image, self.rect)

	def change_content(self, msg):
		'''绘制变内容文本'''
		self.msg = msg
		self.image = self.font.render(self.msg, True, self.color, self.bgcolor)
		self.screen.blit(self.image, self.rect)

def caption(screen, word, height = 500, color = (0,0,0)):
	'''制作字幕'''
	font = pygame.font.SysFont('SimHei', 32)
	i = 0
	for msg in word:
		image = font.render(msg, True, color, (255,255,255))
		rect = image.get_rect()
		rect.topleft = [50, 700 - height + 40*i]
		screen.blit(image, rect)
		i += 1
		pygame.display.update()
		pygame.time.wait(len(msg)*50)
	new_image = font.render('按J以继续', True, (150,150,150), (255,255,255))
	new_rect = new_image.get_rect()
	new_rect.x = rect.right + 10
	new_rect.y = rect.y
	screen.blit(new_image, new_rect)

def say(screen, word, height = 160, color = (0,0,0)):
	'''制作关卡中对话'''
	font = pygame.font.SysFont('SimHei', 24)
	i = 0
	for msg in word:
		image = font.render(msg, True, color, (255,255,255))
		rect = image.get_rect()
		rect.topleft = [50, 700 - height + 30*i]
		screen.blit(image, rect)
		i += 1
