import pygame
from text import say

class React():
	'''可互动的物品'''

	def __init__(self, x, y, name, near = 20):
		'''初始化与其初始位置'''
		self.name = name
		self.far_image = pygame.image.load('images/' + name + '_far.png')
		self.near_image = pygame.image.load('images/' + name + '_near.png')
		self.image = self.far_image
		self.near = near
		self.rect = self.image.get_rect()
		self.rect.center = [x,y]

	def draw(self, screen):
		screen.blit(self.image, self.rect)
		
	def if_near(self, hero):
		'''判定靠近'''
		if hero.rect.centerx - self.rect.centerx <= self.near and self.rect.centerx - hero.rect.centerx <= self.near:
			if hero.rect.bottom - self.rect.bottom <= 10 and self.rect.bottom - hero.rect.bottom <= 10:
				self.image = self.near_image
				return True
		self.image = self.far_image
		return False
		
class Door(React):
	'''门'''

	def __init__(self, x, y):
		super().__init__(x, y, 'door', 10)

	def react(self, hero, screen):
		'''靠近时'''
		if super().if_near(hero):
			return True
		return False

class Note(React):
	'''告示牌'''

	def __init__(self, x, y, msg, near = 40):
		super().__init__(x, y, 'note', near)
		self.msg = msg

	def react(self, hero, screen):
		'''靠近时展示文字'''
		if super().if_near(hero):
			say(screen,[self.msg])

		
