import pygame
from text import *
from hero import Hero
from block import Block
from react import React

def opening(screen, stats):
	'''序幕'''
	level = 1
	while True:
		if level == -1:
			return 'choose'
		elif level == 0:
			return ''
		elif level == 1:
			level = opening_part1(screen)

def opening_part1(screen):
	'''开场字幕'''
	back_button = Text(1150, 670, screen, "返回")
	words = [['序幕','提灯者','“提灯的盲人照亮了前路，也避开了迎面而来的行人。','那么，他的善良是否也是种自私呢？”',''],
			['……………………','…………………………','………………………………'],
			['似乎有人在说话。'],
			['？？？：','看来你已经准备好了，','那，让我们开始治疗吧。'],
			['他是谁？','他在说什么？'],
			['？？？：','先自我介绍一下，我是申屿，','你可以喊我申医生。'],
			['好陌生的名字……'],
			['申屿：','从现在开始，','请按照我的指示进行想象。'],
			['………………'],
			['申屿：','首先，请想象你站在路上，','路的前方有一道门。'],
			['……………………']]
	for word in words:
		screen.fill((255,255,255))
		caption(screen, word)
		back_button.show_text()
		pygame.display.update()
		move_on = False
		while not move_on:
			for event in pygame.event.get():
				if event.type == pygame.QUIT:
					return 0
				elif event.type == pygame.MOUSEBUTTONDOWN:
					pos = pygame.mouse.get_pos()
					if back_button.rect.collidepoint(pos):
						back_button.change_color(200,200,200)
						pygame.display.update()
						pygame.time.wait(200)
						return -1
				if event.type == pygame.KEYDOWN:
					if event.key == pygame.K_j:
						move_on = True
	return 2
