import pygame

class Hero():
	'''主角'''
	
	def __init__(self, x, y, weapon = 'hand', life = 3):
		'''初始化角色'''
		self.max_life = life
		self.life = life
		self.hurt = 0
		
		self.runa = False
		self.rund = False
		self.x_vel = 0
		self.y_vel = 0
		self.face_right = -1
		self.if_left_block = False
		self.if_right_block = False
		self.if_up_block = False
		self.if_down_block = False
		self.push = 0
		self.run_image = 0
		self.rect = pygame.Rect(x,y,45,100)
		self.x = float(x)
		self.y = float(y)
		self.init_weapon(weapon)

		self.static_image = pygame.image.load('images/hero_static.png')
		self.run_image1 = pygame.image.load('images/hero_run1.png')
		self.run_image2 = pygame.image.load('images/hero_run2.png')
		self.run_image3 = pygame.image.load('images/hero_run3.png')
		self.jump_image = pygame.image.load('images/hero_jump.png')
		self.atkhand_image = pygame.image.load('images/hero_atkhand.png')
		self.push_image = pygame.image.load('images/hero_push.png')
		self.leg_static_image = pygame.image.load('images/leg_static.png')
		self.leg_run_image1 = pygame.image.load('images/leg_run1.png')
		self.leg_run_image2 = pygame.image.load('images/leg_run2.png')
		self.leg_run_image3 = pygame.image.load('images/leg_run3.png')
		self.leg_jump_image = pygame.image.load('images/leg_jump.png')
		self.life_image = pygame.image.load('images/heart_full.png')
		self.empty_life_image = pygame.image.load('images/heart_empty.png')
		self.small_life_image = pygame.image.load('images/heart_small.png')
		self.mid_life_image = pygame.image.load('images/heart_mid.png')
		


	def init_weapon(self, weapon):
		'''武器与攻击方面初始化'''
		self.attack = 0
		self.weapon = weapon
		if self.weapon == 'hand':
			self.weapon_image = pygame.image.load('images/weapon_hand.png')
			self.weapon_rect = self.weapon_image.get_rect()
			self.atk_time = 20
			self.renew_time = 10

	def check_event(self, event):
		'''响应键盘'''
		if event.type == pygame.KEYDOWN:
			if event.key == pygame.K_j:
				if not self.attack:
					self.attack = self.atk_time + self.renew_time
			if event.key == pygame.K_a:
				if self.face_right == 1:
					self.face_right = -1
					self.x_vel = 0.0
				self.runa = True
			if event.key == pygame.K_d:
				if self.face_right == -1:
					self.face_right = 1
					self.x_vel = 0.0
				self.rund = True
			if event.key == pygame.K_k:
				if self.if_down_block:
					self.rect.y -= 1
					self.y = self.rect.y
					self.y_vel = -6.0
		if event.type == pygame.KEYUP:
			if event.key == pygame.K_a:
				self.runa = False
			if event.key == pygame.K_d:
				self.rund = False

	def check_spikes_death(self, spikes):
		'''判定撞刺与死亡'''
		if not self.hurt:
			if not self.life:
				return False
			rect = pygame.Rect(self.x - 1, self.y - 1, self.rect.width + 2, self.rect.height + 2)
			for spike in spikes:
				if rect.colliderect(spike):
					self.life -= 1
					self.hurt = 40
					return True
		return True
	
	def check_collision_blocks(self, blocks):
		'''判定与墙或地面碰撞'''
		self.if_left_block = False
		self.if_right_block = False
		self.if_up_block = False
		self.if_down_block = False
		for block in blocks:
			if block.portable:
				block.if_hero_left = False
				block.if_hero_right = False
			if self.rect.left <= block.right and self.rect.left + 5 > block.right:
				if self.rect.top < block.bottom and self.rect.bottom > block.top:
					self.if_left_block = True
					self.left = block.right
					self.x = float(self.rect.x)
					if block.portable:
						block.if_hero_right = True
						self.push = 6
			if self.rect.right >= block.left and self.rect.right - 5 < block.left:
				if self.rect.top < block.bottom and self.rect.bottom > block.top:
					self.if_right_block = True
					self.rect.right = block.left
					self.x = float(self.rect.x)
					if block.portable:
						block.if_hero_left = True
						self.push = 6
			if self.rect.bottom >= block.top and self.rect.bottom - 10 < block.top:
				if self.rect.left < block.right and self.rect.right > block.left:
					self.if_down_block = True
					self.rect.bottom = block.top
					self.y = float(self.rect.y)
			if self.rect.top <= block.bottom and self.rect.top + 10 > block.bottom:
				if self.rect.left < block.right and self.rect.right > block.left:
					self.if_up_block = True
					self.rect.top = block.bottom
					self.y = float(self.rect.y)
			block.update()

	def update_location(self):
		'''更新主角位置'''
		if self.runa or self.rund:
			if self.x_vel < 4:
				self.x_vel += (4 - self.x_vel)*0.1
		if not self.runa and not self.rund and self.x_vel > 0:
			self.x_vel -= 0.2
			if self.x_vel < 0:
				self.x_vel = 0.0
		if self.face_right == 1 and self.if_right_block:
			self.x_vel = 0.0
		if self.face_right == -1 and self.if_left_block:
			self.x_vel = 0.0
		self.x += self.x_vel*self.face_right
		self.rect.x = self.x
		if self.if_up_block and self.y_vel < 0:
				self.y_vel *= -1
		if self.if_down_block:
			self.y_vel = 0.0
		else:
			self.y_vel += 0.15
		self.y += self.y_vel
		self.rect.y = self.y

	def draw_life(self, screen):
		'''绘制生命条'''
		rect = self.life_image.get_rect()
		rect.center = [30,30]
		i = -1
		for i in range(0,self.life):
			screen.blit(self.life_image,rect)
			rect.x += 50
		if self.hurt > 20:
			screen.blit(self.mid_life_image,rect)
			rect.x += 50
			i += 1
		elif self.hurt:
			screen.blit(self.small_life_image,rect)
			rect.x += 50
			i += 1
		for j in range(i+1, self.max_life):
			screen.blit(self.empty_life_image,rect)
			rect.x += 50
	
	def draw(self, screen):
		'''绘制主角'''
		if self.hurt:
			self.hurt -= 1
			if self.hurt%10 > 5:
				return 
		if not self.if_down_block:
				hand_image = self.jump_image
				leg_image = self.leg_jump_image
		elif self.runa or self.rund:
			self.run_image += 1
			if self.run_image == 24:
				self.run_image = 0
			if self.run_image < 6:
				hand_image = self.run_image1
				leg_image = self.leg_run_image1
			elif self.run_image < 12:
				hand_image = self.run_image3
				leg_image = self.leg_run_image3
			elif self.run_image < 18:
				hand_image = self.run_image2
				leg_image = self.leg_run_image2
			else:
				hand_image = self.run_image3
				leg_image = self.leg_run_image3
		else:
			hand_image = self.static_image
			leg_image = self.leg_static_image
		if self.push:
			self.attack = 0
			self.push -= 1
			hand_image = self.push_image

		elif self.attack:
			if self.weapon == 'hand':
				self.attack -= 1
				if self.attack > self.renew_time:
					hand_image = self.atkhand_image
					self.weapon_rect.bottom = self.rect.bottom - 38
					if self.face_right == 1:
						self.weapon_rect.left = self.rect.right
						weapon_image = self.weapon_image
					else:
						self.weapon_rect.right = self.rect.left
						weapon_image = pygame.transform.flip(self.weapon_image, True, False)
					screen.blit(weapon_image, self.weapon_rect)
				
		
		if self.face_right == -1:
			hand_image = pygame.transform.flip(hand_image, True, False)
			leg_image = pygame.transform.flip(leg_image, True, False)
		hand_rect = hand_image.get_rect()
		hand_rect.x = self.x
		hand_rect.y = self.y
		screen.blit(hand_image, self.rect)
		leg_rect = leg_image.get_rect()
		leg_rect.x = self.x
		leg_rect.y = self.y + 77
		screen.blit(leg_image, leg_rect)

	def check_update_draw(self, spikes, blocks, screen):
		'''更新状态并返回是否存活'''
		alive = self.check_spikes_death(spikes)
		self.check_collision_blocks(blocks)
		self.update_location()
		self.draw_life(screen)
		self.draw(screen)
		return alive

