import pygame
from text import Text

def help_settings(screen, stats):
	'''帮助与设置界面'''
	clear_button = Text(600, 600, screen, "清除现有进度")
	music_button = Text(600, 550, screen, "音乐：开启")
	sound_button = Text(600, 500, screen, "音效：开启")
	back_button = Text(1150, 670, screen, "返回")
	help_pic = pygame.image.load('images/help.png')
	help_rect = help_pic.get_rect()
	help_rect.center = [600,200]
	
	screen.fill((255,255,255))
	screen.blit(help_pic, help_rect)

	clear_ready = 0
	
	while True:
		if stats.if_play_music:
			music_button.change_content("音乐：开启")
		else:
			music_button.change_content("音乐：关闭")
		if stats.if_play_sound:
			sound_button.change_content("音效：开启")
		else:
			sound_button.change_content("音效：关闭")
		if clear_ready:
			clear_button.change_content("再次点击确认")
		else:
			clear_button.change_content("清除现有进度")
		back_button.show_text()
		pygame.display.update()
		
		for event in pygame.event.get():
			if event.type == pygame.QUIT:
				return
			elif event.type == pygame.MOUSEBUTTONDOWN:
				pos = pygame.mouse.get_pos()
				if back_button.rect.collidepoint(pos):
					back_button.change_color(200,200,200)
					pygame.display.update()
					pygame.time.wait(200)
					return
				elif music_button.rect.collidepoint(pos):
					if stats.if_play_music:
						pygame.mixer.music.stop()
						stats.if_play_music = 0
					else:
						pygame.mixer.music.load('audios/title.mp3')
						pygame.mixer.music.play(-1, 0)
						stats.if_play_music = 1
				elif sound_button.rect.collidepoint(pos):
					stats.if_play_sound = 1 - stats.if_play_sound
				elif clear_button.rect.collidepoint(pos):
					if clear_ready:
						stats.clear()
					clear_ready = 1 - clear_ready
