import pygame

class Block(pygame.Rect):

	def __init__(self, x, y, width, height, name = '', portable = 0, hidden = False):
		"""初始化碰撞箱与其初始位置、大小"""
		super().__init__(x, y, width, height)
		self.portable = portable
		self.hidden = hidden
		self.name = name
		
		if self.portable:
			self.if_hero_left = False
			self.if_hero_right = False
			self.count = 0

		if name:
			self.image = pygame.image.load('images/'+name+'.png')
		
	def draw(self, screen, color = ()):
		"""在屏幕上绘制墙壁"""
		if not self.hidden:
			if self.name:
				screen.blit(self.image, self)
			elif color:
				pygame.draw.rect(screen, color, self, 2)				
			elif self.portable:
				pygame.draw.rect(screen, (200,200,100), self, 2)
			else:
				pygame.draw.rect(screen, (0,0,0), self, 2)

	def update(self):
		if self.portable:
			if self.if_hero_left:
				self.x += self.portable
			if self.if_hero_right:
				self.x -= self.portable
		
