from os import system
from time import sleep
from msvcrt import kbhit, getch

OUT_PATH = "save.txt"

def flush_in():
    while kbhit():
        getch()

def wait_for_enter(string = ""):
    if string: print(string)
    while not kbhit() or getch() != b'\r':
        sleep(0.03)
    flush_in()

def intro_in():
    system("cls")
    print(L + "\n  欢迎来到SCL-90测试程序！\n" + L)
    name = input("姓名：")
    if name == "于寒" or name == "":
        return "", -1
    system("cls")
    print(L + "\n  欢迎来到SCL-90测试程序！\n" + L)
    wait_for_enter("姓名：于寒")
    wait_for_enter("年龄：28")
    out = input("请输入0进行确认：")
    if out != "0":
        return "", -2
    return name, 0

def intro():
    system("cls")
    try:
        with open(OUT_PATH, "r") as f:
            name = f.readline().strip()
            status = int(f.readline())
        if name != "":
            if status == 0:
                wait_for_enter("将从存档点 [首次测试] 开始，回车继续")
            elif status == 1:
                wait_for_enter("将从存档点 [真相之始] 开始，回车继续") 
            elif status == 2:
                wait_for_enter("将从存档点 [无法逃脱] 开始，回车继续")
            elif status == 3:
                wait_for_enter("将从存档点 [年复一年] 开始，回车继续")
            elif status == 4:
                wait_for_enter("将从存档点 [最后通牒] 开始，回车继续")
            elif status == 5:
                wait_for_enter("将从存档点 [第三条路] 开始，回车继续")
            elif status == 8:
                wait_for_enter("将从存档点 [辩护人生] 开始，回车继续")
            return name, status
    except:
        pass
    status = -1
    name = ""
    print("操作说明：")
    wait_for_enter("用WS进行上下选择、打字进行输入，用回车键确认/前进。")
    wait_for_enter("制作：原生生物")
    wait_for_enter("版本：1.0")
    wait_for_enter("祝你好运！")
    while status < 0:
        name, status = intro_in()
        system("cls")
        if status == -1:
            print("由于您并未输入合适的姓名，请重新开始。")
        elif status == -2:
            print("由于您拒绝了本次心理测试，请重新开始。")
        elif status == 0:
            with open(OUT_PATH, "w") as f:
                f.write(name + "\n0\n")
            print(L)
            print("[进度已保存] 感谢您的配合，请阅读测试须知：")
            print("以下表格中列出了有些人可能有的病痛或问题，请务必仔细阅读每一条，然后根据最近一星期以内下列问题影响你或使你感到苦恼的程度，选择最合适的一项。")
            print(L)
        wait_for_enter()
    return name, 0

L = "=" * 50
Q = L + "\n    SCL-90 Questions\n" + L + "\n "
C = ["从无", "轻度", "中度", "偏重", "严重"]

question_list = ["头痛",
                 "神经过敏，心中不踏实",
                 "头脑中有不必要的想法或字句盘旋",
                 "头昏或昏倒",
                 "对异性的兴趣减退",
                 "对旁人责备求全",
                 "感到别人能控制您的思想",
                 "责怪别人制造麻烦",
                 "忘性大",
                 "担心自己衣饰是否整齐、仪态是否端正",
                 "容易烦恼和激动",
                 "胸痛",
                 "害怕空旷的场所或街道",
                 "感到自己精力下降，活动减慢",
                 "想结束自己的生命",
                 "听到旁人听不到的声音",
                 "发抖",
                 "感到大多数人都不可信任",
                 "胃口不好",
                 "容易哭泣",
                 "同异性相处时感到害羞和不自在",
                 "感到受骗，中了圈套或有人想抓住您",
                 "无缘无故突然感到害怕",
                 "无法控制地大发脾气",
                 "怕单独出门",
                 "经常责怪自己",
                 "腰痛",
                 "感到难以完成任务",
                 "感到孤独",
                 "感到苦闷",
                 "过分担忧",
                 "对事物不感兴趣",
                 "感到害怕",
                 "您的感情容易受到伤害",
                 "旁人能知道您的私下想法",
                 "感到别人不理解您、不同情您",
                 "感到人们对您不友好，不喜欢您",
                 "做事必须很慢以保证正确",
                 "心跳得很厉害",
                 "恶心或胃部不舒服",
                 "感到比不上他人",
                 "肌肉酸痛",
                 "感到有人在监视您、谈论您",
                 "难以入睡",
                 "做事必须反复检查",
                 "难以做出决定",
                 "怕乘公共交通工具",
                 "呼吸有困难",
                 "一阵阵发冷或发热",
                 "出于害怕而避开某些东西、场合或活动",
                 "脑子变空了",
                 "身体发麻或刺痛",
                 "喉咙有梗塞感",
                 "感到前途没有希望",
                 "不能集中注意力",
                 "感到身体的某一部分软弱无力",
                 "感到紧张或容易紧张",
                 "感到手或脚发重",
                 "想到死亡的事",
                 "吃得太多",
                 "当别人看着您或谈论您时感到不自在",
                 "有一些不属于您自己的想法",
                 "有想打人或伤害他人的冲动",
                 "醒得太早",
                 "必须反复洗手、点数",
                 "睡得不稳、不深",
                 "有想摔坏或破坏东西的想法",
                 "有一些别人没有的想法",
                 "感到对别人神经过敏",
                 "在商店或电影院等人多的地方不自在",
                 "感到任何事情都很困难",
                 "一阵阵恐惧或惊恐",
                 "感到公共场合吃东西很不舒服",
                 "经常与人争论",
                 "单独一人时神经很紧张",
                 "别人对您的成绩没有做出恰当的评价",
                 "即使和别人在一起也感到孤单",
                 "感到坐立不安心神不宁",
                 "感到自己没有什么价值",
                 "感到熟悉的东西变成陌生或不像是真的",
                 "大叫或摔东西",
                 "害怕会在公共场合昏倒",
                 "感到别人想占您的便宜",
                 "为一些有关性的想法而很苦恼",
                 "认为应该因为自己的过错而受惩罚",
                 "感到要很快把事情做完",
                 "感到自己的身体有严重问题",
                 "从未感到和其他人很亲近",
                 "感到自己有罪",
                 "感到自己的脑子有毛病"]

def choice(question, qlist, foot):
    now = 0
    while True:
        system("cls")
        l = len(qlist)
        print(question)
        for i in range(l):
            if i == now:
                print("   -> ", end="")
            else:
                print("      ", end="")
            print(qlist[i])
        print(foot)
        while True:
            sleep(0.03)
            if kbhit():
                res = getch()
                flush_in()
                if res == b's':
                    now = (now + 1) % l
                    break
                elif res == b'w':
                    now = (now + l - 1) % l
                    break
                elif res == b'\r':
                    return now

def choice_1_26():
    now = 4
    ws26 = ["哦？", "发现自己动不了了吗？", "毕竟，怎么会不是严重呢？", "你自己应该清楚。", "……", "……"]
    now_ws = -1
    e26 = ["就在这里结束吧。", "这对你我都好，不是吗？", "如果你连我都不放过的话……", "……", "……"]
    now_e = -1
    en = 0
    while True:
        system("cls")
        print(Q + "26. " + question_list[25])
        for i in range(5):
            if i == now:
                print("   -> ", end="")
            else:
                print("      ", end="")
            print(C[i])
        print(L)
        if en == 1:
            print(ws26[now_ws])
        elif en == 2:
            print(e26[now_e])
        while True:
            sleep(0.03)
            if kbhit():
                res = getch()
                flush_in()
                if res == b's' or res == b'w':
                    en = 1
                    now_ws = min(now_ws + 1, 5)
                    break
                elif res == b'\r':
                    en = 2
                    now_e = min(now_e + 1, 4)
                    break
        if now_ws == 5 and now_e == 4:
            return

def choice_1_27_31(r):
    now = 0
    while True:
        system("cls")
        q_list = ["腰痛", "感到??以完??任务", "????孤独", "感????????", "??????????????"]
        w = ["回", "回 想", "回 想 起", "回 想 起 来", "回 想 起 来 吧"]
        print(Q + str(r + 1) +  ". " + q_list[r - 26])
        c = ["从无", "轻度", "中度", "偏重", "严重"]
        c[r - 26] = "回想"
        for i in range(5):
            if i == now:
                print("   -> ", end="")
            else:
                print("      ", end="")
            print(c[i])
        print(L + "\n" + w[r - 26])
        while True:
            sleep(0.03)
            if kbhit():
                res = getch()
                flush_in()
                if res == b's':
                    now = (now + 1) % 5
                    break
                elif res == b'w':
                    now = (now + 4) % 5
                    break
                elif res == b'\r':
                    if now == r - 26:
                        return


def cycle_1(name):
    sleep(0.5)
    word = {
        5: ["喂。", "M"],
        8: ["我说，无聊的填表游戏要玩到什么时候？", "y"],
        10: ["你知道这里是哪里。", "A"],
        12: ["你也知道自己在做什么。", "g"],
        13: ["你更知道我是谁，对吧。", "e"],
        15: ["……", "I"],
        16: ["真是无趣。", "s"],
        18: ["那么，就由我来提醒你好了。", "S"],
        19: ["我叫" + name + "。", "e"],
        20: ["有点印象了吗？", "v"],
        22: ["……还没有想起来吗。", "e"],
        24: ["看来，是时候采取一点措施了。", "n"]
    }

    # Q1 - Q25
    for i in range(25):
        if i in word:
            choice(Q + word[i][1] + ". " + question_list[i], C, L + "\n" + word[i][0])
        else:
            choice(Q + str(i + 1) + ". " + question_list[i], C, L)

    # Q26
    choice_1_26()

    # Puzzle 0
    system("cls")
    wait_for_enter("好吧。")
    wait_for_enter("既然你如此锲而不舍，")
    wait_for_enter("那我就给你一个机会好了。")
    wait_for_enter("你现在，一定很想知道自己为什么在这里吧。")
    wait_for_enter("只不过，真相可能不像你预料中的那么美好。")
    wait_for_enter("——更多时候，它会令人痛苦。")
    wait_for_enter("在这之前，希望你能通过我的小小考验。")
    while True:
        system("cls")
        age = input("我的年龄是：")
        try:
            age = int(age)
        except:
            wait_for_enter("[请输入数字！]")
            continue
        if age == 7:
            wait_for_enter("……还不错。")
            break
        if age == -1:
            wait_for_enter("[重做一次测试 注意序号变化]")
            wait_for_enter("[输入 -3 重新开始测试]")
        elif age == -2:
            wait_for_enter("[出现对话时的序号可以连成一句话]")
            wait_for_enter("[输入 -3 重新开始测试]")
        elif age == -3:
            return False, 0
        else:
            wait_for_enter("[输入 -1 获取提示，输入 -2 获取详细提示]")

    # Q27 - Q31
    for i in range(26, 31):
        choice_1_27_31(i)

    with open(OUT_PATH, "w") as f:
        f.write(name + "\n1\n")
    
    for i in range(20):
        sleep(0.03)
        print("?" * 1000)
    system("cls")
    print("系统检测到未知错误而崩溃，请稍候……")
    sleep(3)
    print("[游戏名：Dr.S - 辩护]")
    ret = input("[进度已保存] 输入0以退出，输入其他以重启系统：")
    return ret == "0", 1


def intro_2(age):
    system("cls")
    wait_for_enter(L + "\n  欢迎来到SCL-90测试程序！\n" + L)
    wait_for_enter("姓名：于寒")
    wait_for_enter("年龄：" + str(age))
    wait_for_enter("按回车开始测试。")
    system("cls")
    print(L)
    print("感谢您的配合，请阅读测试须知：")
    wait_for_enter("以下表格中列出了有些人可能有的病痛或问题，请务必仔细阅读每一条，然后根据最近一星期以内下列问题影响你或使你感到苦恼的程度，选择最合适的一项。\n" + L)

def choice_2_1():
    now = 0
    pos = 0
    c = ["从无", "从无", "从无", "从无", "从无"]
    l = len(c)
    while True:
        system("cls")
        print(Q + "6. " + "打开门")
        for i in range(l):
            if i == now:
                print("  " * pos + "   -> ", end="")
            else:
                print("      ", end="")
            print(c[i])
        print(L)
        while True:
            sleep(0.03)
            if kbhit():
                res = getch()
                flush_in()
                if res == b's' and not pos:
                    now = (now + 1) % l
                    break
                elif res == b'w' and not pos:
                    now = (now + l - 1) % l
                    break
                elif res == b'\r':
                    if now != 3:
                        c[now] = "此路不通"
                        break
                    else:
                        c[now] = ""
                        pos += 1
                        if pos == 5: c[now] = "开门"
                        if pos == 6: return
                        break

def choice_2_2():
    now = 0
    pos = 0
    c = ["从无", "从无", "从无", "从无", "从无"]
    a = ["使用", "A与D", "左右", "移动", "从无"]
    l = len(c)
    while True:
        system("cls")
        print(Q + "14. " + "打开门")
        for i in range(l):
            if i == now:
                if pos == 0:
                    print("   -> " + c[i])
                elif pos < 6:
                    print("      " + c[i] + (pos - 1) * "  " + "->")
                else:
                    print("      " + c[i] + 5 * "  " + "->", end = "")
                    if now == 4: print("开门")
                    else: print("此路不通")
            else:
                print("      " + c[i])
        print(L)
        while True:
            sleep(0.03)
            if kbhit():
                res = getch()
                flush_in()
                if res == b's':
                    now = (now + 1) % l
                    break
                elif res == b'w':
                    now = (now + l - 1) % l
                    break
                elif res == b'\r':
                    c[now] = a[now]
                    if now == 4 and pos == 6:
                        return
                    break
                elif res == b'a':
                    pos = max(pos - 1, 0)
                    break
                elif res == b'd':
                    pos = min(pos + 1, 6)
                    break


def cycle_2(name):
    intro_2(21)

    system("cls")
    wait_for_enter()
    wait_for_enter("今天是我的21岁生日，也是大四开学前的最后一个周末。")
    wait_for_enter("我已经在林鸥大学读了整整三年法律了。")
    wait_for_enter("父母都希望我能去鹰吕打拼，但我却更想留在林鸥市。")
    wait_for_enter("——或许，繁忙的沿海城市本来就不适合我。")
    wait_for_enter("朋友们替我点了一份蛋糕，是我最喜欢的草莓口味。")
    wait_for_enter("灯已经关上了，小小的火焰跳动着橘红色的光影。")
    wait_for_enter("该吹蜡烛了。")
    for t in [0.6, 0.4, 0.2, 0.1, 0.1, 0.1, 0.1]:
        system("cls")
        sleep(t)
        print("今天是我的21岁生日，也是大四开学前的最后一个周末。")
        print("我已经在林鸥大学读了整整三年法律了。")
        print("父母都希望我能去鹰吕打拼，但我却更想留在林鸥市。")
        print("——或许，繁忙的沿海城市本来就不适合我。")
        print("朋友们替我点了一份蛋糕，是我最喜欢的草莓口味。")
        print("灯已经关上了，小小的火焰跳动着橘红色的光影。")
        print("该吹蜡烛了。")
        sleep(t)
    system("cls")
    wait_for_enter()

    word = {
        0: "真是个完美的生日啊。",
        1: "不过，好像有个奇怪的事哦。",
        2: "为什么你会在这样的时候填量表呢？",
        3: "学校不会在暑假发什么心理普查。",
        4: "除此之外——",
        6: "看吧，这才是真实的你。",
        7: "轻描淡写的一句“更想留在林鸥”，怎么能代表你的经历呢？",
        8: "顺带一提，你现在在的地方，叫做心灵迷宫。",
        9: "每扇门，都代表着你的[回忆]。",
        10: "而迷宫的主体，就是这份量表。",
        11: "为什么呢——",
        12: "我们继续往下看吧。",
        14: "好吧。",
        15: "那么事情就是这样。",
        16: "在21岁生日的几天前，你和父母为了要不要留在林鸥市大吵了一架。",
        17: "看起来你自己也觉得这并不是多大的事，所以“门”藏得一点也不深。",
        18: "真是无趣的故事啊，让我们赶快进入下一段吧。"
    }

    # Q1 - Q5
    for i in range(5):
        choice(Q + str(i + 1) + ". " + question_list[i], C, L + "\n" + word[i])

    # Puzzle 1
    choice_2_1()
    
    system("cls")
    wait_for_enter()
    wait_for_enter("——有完没完！")
    wait_for_enter("——反正我要留在林鸥市，你们爱怎么说怎么说。")
    wait_for_enter("——我自己几斤几两我心里有数，不用你们教！")
    for t in [0.05] * 10:
        system("cls")
        sleep(t)
        print("——有完没完！")
        print("——反正我要留在林鸥市，你们爱怎么说怎么说。")
        print("——我自己几斤几两我心里有数，不用你们教！")
        sleep(t)
    system("cls")
    wait_for_enter()

    # Q7 - Q13
    for i in range(6, 13):
        choice(Q + str(i + 1) + ". " + question_list[i], C, L + "\n" + word[i])

    # Puzzle 2
    choice_2_2()

    # Q15 - Q19
    for i in range(14, 19):
        choice(Q + str(i + 1) + ". " + question_list[i], C, L + "\n" + word[i])

    with open(OUT_PATH, "w") as f:
        f.write(name + "\n2\n")

    ret = input("[进度已保存] 输入0以退出，输入其他以继续：")
    return ret == "0", 2

def choice_3_1():
    pos = -2
    while True:
        system("cls")
        print(L + "\n    SCL-90 Results\n" + L)
        print("      总均分: 2.37")
        print("      躯体化: 轻 (1.58)")
        print("      强迫症状: 中 (2.70)")
        print("      人际关系: 轻 (2.11)")
        print("      抑郁: 中 (3.31)")
        print("      焦虑: 轻 (2.40)")
        print("      敌对: 轻 (2.17)")
        print("      恐惧: 无 (1.29)")
        print("      偏执: 轻 (2.33)")
        print("      精神病性: 中 (2.60)")
        print("      其他: 中 (2.71)")
        ret = input(L + "\n请输入 0 重新测试，输入 1 结束测试：")
        if ret == '0':
            print("这里藏着一扇门。")
            if pos >= 0:
                print(pos * " " + "^")
            while True:
                sleep(0.03)
                if kbhit():
                    res = getch()
                    flush_in()
                    if res == b'\r':
                        if pos == 12:
                            return
                        break
                    elif res == b'a':
                        pos = max(pos - 2, 0)
                        break
                    elif res == b'd':
                        if pos >= 0:
                            pos = min(pos + 2, 16)
                        break
        elif ret == '1':
            if pos < 0: pos = 0
            wait_for_enter("系统故障，结束测试失败，请重试\n" + pos * " " + "^") 
        elif ret == "-1":
            wait_for_enter("[别忘了A与D]")
        elif ret == "-2":
            wait_for_enter("[在看到^后左右移动到门的位置，并按回车]")
        else:
            wait_for_enter("[输入 -1 获取提示，输入 -2 获取详细提示]")

def choice_3_2():
    now = 0
    word = [
        "谎言，又是无聊的谎言。",
        "你明明和陈目联系了不少次才对。",
        "讽刺的是，他在鹰吕混得并不好。",
        "正如你曾担心自己的那样，他的水平也仅仅是在林鸥还算够看。",
        "在鹰吕那样全国精英汇聚的地方，他根本算不上什么。",
        "于是你很得意。",
        "那是种带着微妙的爽快感的得意，隐藏在你的关心之中。",
        "你背地同朋友嘲笑着他，希望证明自己的正确。",
        "好吧，这一切都没什么。",
        "只是让你更加纠结了而已。",
        "——你以为你的抑郁只是现在压力的结果吗？",
        "总之，平安无事的一年过去了。",
        "毕竟你才刚入职，也很难说摸清了里面的什么门道。",
        "好了，闲话就说到这里。",
        "该修复系统，进入下一段故事了。",
        "需要打开的位置就是该输入的密码。",
        "——什么，你问位置是什么意思？",
        "比如，刚才的话里，“陈”的位置就是5，“目”的位置就是6，“林”则是27。"
    ]
    while True:
        system("cls")
        print(L + "\n    SCL-90 Results\n" + L)
        print("      总均分: 2.37")
        print("      躯体化: 轻 (1.58)")
        print("      强迫症状: 中 (2.70)")
        print("      人际关系: 轻 (2.11)")
        print("      抑郁: 中 (3.31)")
        print("      焦虑: 轻 (2.40)")
        print("      敌对: 轻 (2.17)")
        print("      恐惧: 无 (1.29)")
        print("      偏执: 轻 (2.33)")
        print("      精神病性: 中 (2.60)")
        print("      其他: 中 (2.71)")
        ret = input(L + "\n请输入 0 重新测试，输入 1 结束测试：")
        if ret == '0':
            wait_for_enter(word[now])
            now = (now + 1) % len(word)
        elif ret == "1":
            wait_for_enter("系统故障，结束测试失败，请重试")
        elif ret == "-1":
            wait_for_enter("[在刚才的话里寻找吧]")
        elif ret == "-2":
            wait_for_enter("[找到“门”所在的那句话里门的位置]")
        elif ret == "21":
            wait_for_enter("测试已结束，回车继续")
            return
        else:
            wait_for_enter("[输入 -1 获取提示，输入 -2 获取详细提示]")

def cycle_3(name):
    intro_2(22)

    system("cls")
    wait_for_enter()
    wait_for_enter("今年，我大学毕业了。")
    wait_for_enter("在林鸥找了一家律师事务所实习。")
    wait_for_enter("——最后还是没去鹰吕深造或是工作。")
    wait_for_enter("只有我自己知道我如此不愿意去那里的原因。")
    wait_for_enter("虽然我确实得到了机会，但从林鸥这样的小城出来的人，无论是眼界还是经验都没法和鹰吕的同龄人相比。")
    wait_for_enter("所以我很有自知之明地选择了放弃。")
    wait_for_enter("更何况，林鸥这里其实也不差。")
    print("……")

    sleep(2)
    word = ["既然你也不想再看到麻烦的量表，就直接来到结果环节吧。",
            "总均分都接近2.5了，看起来可不算正常哦。",
            "这一年里，都发生了什么呢？"]
    now = 0
    while True:
        system("cls")
        print(L + "\n    SCL-90 Results\n" + L)
        print("      总均分: 2.37")
        print("      躯体化: 轻 (1.58)")
        print("      强迫症状: 中 (2.70)")
        print("      人际关系: 轻 (2.11)")
        print("      抑郁: 中 (3.31)")
        print("      焦虑: 轻 (2.40)")
        print("      敌对: 轻 (2.17)")
        print("      恐惧: 无 (1.29)")
        print("      偏执: 轻 (2.33)")
        print("      精神病性: 中 (2.60)")
        print("      其他: 中 (2.71)")
        ret = input(L + "\n请输入 0 重新测试，输入 1 结束测试：")
        if ret == '0':
            wait_for_enter(word[now])
            now += 1
            if now == len(word): break
        if ret == '1':
            wait_for_enter("系统故障，结束测试失败，请重试")

    system("cls")
    wait_for_enter()
    wait_for_enter("我有个同学，叫陈目，物理系。")
    wait_for_enter("SCL-90量表还是生日时候他拿给我的，说看我那段时间压力挺大，让我测着玩玩。")
    wait_for_enter("当然，去年我没测出任何问题。")
    wait_for_enter("比起现在开始实习来说，去年只是关于去向争论几句，真是再轻松不过了。")
    wait_for_enter("奇怪的是，这段时间，脑海中的有个声音更加强烈了。")
    wait_for_enter("那个声音自称" + name + "，总是会在恰到好处的时机奚落我。")
    wait_for_enter("估计是紧张的时候想多了，还是很正常。")
    wait_for_enter("……大概。")

    # Puzzle 3
    choice_3_1()

    system("cls")
    wait_for_enter()
    wait_for_enter("陈目的成绩挺好，最后如愿去了鹰吕市读研，之后我们也没有再联系过。")
    wait_for_enter("我时常会想，那时的选择究竟是不是正确呢？")
    wait_for_enter("说是很清楚自己的水平，某种意义上，可能也只是逃避而已。")
    wait_for_enter("反过来说，逃避也没什么不好的。")
    wait_for_enter("按照最近测量表的结果，我现在的状态都已经这么差了，真去了鹰吕，恐怕只会更累。")
    
    # Puzzle 4
    choice_3_2()

    with open(OUT_PATH, "w") as f:
        f.write(name + "\n3\n")
    
    ret = input("[进度已保存] 输入0以退出，输入其他以继续：")
    return ret == "0", 3

def choice_4_1():
    Maze = [
        "|你又在说谎了。",
        "|    试图掩盖失败是没用的。",
        "|非要我 拆穿",
        "|才明白 吗？",
        "|不过  打开",
        "|一扇门而已，",
        "|对你而言真的有这么难吗？",
        "  [使用WSAD控制]"
    ]
    now = [1, 1]
    count = 0
    while True:
        system("cls")
        for i in range(len(Maze)):
            for j in range(len(Maze[i])):
                if Maze[i][j] != " ":
                    print(Maze[i][j], end = "")
                elif now[0] == i and now[1] == j:
                    print("<>", end = "")
                else:
                    print("  ", end = "")
            print()
        count += 1
        if count == 20: Maze.append("  [前往“门”上]")
        while True:
            sleep(0.03)
            if kbhit():
                res = getch()
                flush_in()
                if res == b'w':
                    if Maze[now[0] - 1][now[1]] == " ":
                        now[0] -= 1
                        break
                elif res == b's':
                    if Maze[now[0] + 1][now[1]] == " ":
                        now[0] += 1
                        break
                    if Maze[now[0] + 1][now[1]] == "门":
                        return
                elif res == b'a':
                    if Maze[now[0]][now[1] - 1] == " ":
                        now[1] -= 1
                        break
                elif res == b'd':
                    if Maze[now[0]][now[1] + 1] == " ":
                        now[1] += 1
                        break


def choice_4_2():
    Maze = [
        "|你们律所的合伙人之一",
        "|    本来就有门路，也愿意给你机会。",
        "|争取到 那个项目 对你来说其实也不难。",
        "|可你做  了什么？\t",
        "|  但求  无过？\t",
        "|给混日子找 借口 罢了。",
        "|          可笑。",
        "|不过嘛，混着混着，总还是有出事的那一刻。",
        "|想想你今年又干了什么蠢事吧。"
    ]
    now = [1, 1]
    count = 0
    while True:
        system("cls")
        for i in range(len(Maze)):
            for j in range(len(Maze[i])):
                if Maze[i][j] != " ":
                    print(Maze[i][j], end = "")
                elif now[0] == i and now[1] == j:
                    print("<>", end = "")
                else:
                    print("  ", end = "")
            print()
        count += 1
        if count == 40: Maze.append("  [问号也可以通过]")
        while True:
            sleep(0.03)
            if kbhit():
                res = getch()
                flush_in()
                if res == b'w':
                    if Maze[now[0] - 1][now[1]] in " ？":
                        now[0] -= 1
                        break
                    if Maze[now[0] - 1][now[1]] == "门":
                        return
                elif res == b's':
                    if Maze[now[0] + 1][now[1]] in " ？":
                        now[0] += 1
                        break
                elif res == b'a':
                    if Maze[now[0]][now[1] - 1] in " ？":
                        now[1] -= 1
                        break
                elif res == b'd':
                    if Maze[now[0]][now[1] + 1] in " ？":
                        now[1] += 1
                        break

def choice_4_3():
    Maze = [
        "|负责一个拆迁款分割纠纷，",
        "| 忘了给财产保全申请续保。",
        "|   结果呢？ 赢是赢了，钱没拿到。",
        "|对面 趁  锁定的存款解除了冻结，",
        "|     把名下财产都转移走了。",
        "|强制执行 失败，最后只拿到一半的应得款。"
    ]
    now = [1, 1]
    count = 0
    me = "<>"
    while True:
        system("cls")
        for i in range(len(Maze)):
            for j in range(len(Maze[i])):
                if Maze[i][j] != " ":
                    print(Maze[i][j], end = "")
                elif now[0] == i and now[1] == j:
                    print(me, end = "")
                else:
                    print("  ", end = "")
            print()
        count += 1
        if count == 2: Maze.append("|你们被判  赔偿80%的损失。")
        if count == 5: Maze.append("|比起这个， 之前那几次")
        if count == 8: Maze.append("|弄丢办公室钥匙都不算什么了。")
        if count == 11: Maze.append("|还用我补充之后的事吗？")
        if count == 40: Maze.append("  [用钥匙打开锁，目标是赢]")
        while True:
            sleep(0.03)
            if kbhit():
                res = getch()
                flush_in()
                if res == b'w':
                    if Maze[now[0] - 1][now[1]] in " ？":
                        now[0] -= 1
                        break
                elif res == b's':
                    if Maze[now[0] + 1][now[1]] in " ？":
                        now[0] += 1
                        break
                    if Maze[now[0] + 1][now[1]] == "钥":
                        now[0] += 1
                        me = "钥"
                        Maze[now[0]] = Maze[now[0]].replace("钥", " ")
                        break
                elif res == b'a':
                    if Maze[now[0]][now[1] - 1] in " ？":
                        now[1] -= 1
                        break
                elif res == b'd':
                    if Maze[now[0]][now[1] + 1] in " ？":
                        now[1] += 1
                        break
                    if Maze[now[0]][now[1] + 1] == "锁" and me == "钥":
                        me = "<>"
                        Maze[now[0]] = Maze[now[0]].replace("锁", " ")
                        break
                    if Maze[now[0]][now[1] + 1] == "赢":
                        return

def choice_4_4():
    Maze = [
        "|你给自己找了很多借口，",
        "| 说你是新人，说律所其他人也犯过类似的错。",
        "|  你也确实没背上太大的罚款。"
    ]
    now = [1, 1]
    count = 0
    me = "<>"
    while True:
        system("cls")
        for i in range(len(Maze)):
            for j in range(len(Maze[i])):
                if Maze[i][j] != " ":
                    print(Maze[i][j], end = "")
                elif now[0] == i and now[1] == j:
                    print(me, end = "")
                else:
                    print("  ", end = "")
            print()
        count += 1
        if count == 1: Maze.append("|但  你知道，之后的有些机会，")
        elif count == 3: Maze.append("|大概  不会属于你了。")
        elif count == 5: Maze.append("|还有些  更糟糕的事。")
        elif count == 7: Maze.append("|你意识到  自己毫无建树地浪费了三年人生。")
        elif count == 9: Maze.append("|可是错过的  就是错过了。")
        elif count == 11: Maze.append("|陈目顺利转博  ，日子有了起色。")
        elif count == 13: Maze.append("|你早就不再和他  联系了。")
        elif count == 15: Maze.append("|不用再看你的测试  结果了吧。")
        elif count == 17: Maze.append("|从来没经过什么大挫折的你，")
        elif count == 19: Maze.append("|被永远堵死在了那扇门后。")
        elif count == 27: return
        while True:
            sleep(0.03)
            if kbhit():
                res = getch()
                flush_in()
                if res == b'w':
                    if Maze[now[0] - 1][now[1]] in " ？":
                        now[0] -= 1
                        break
                elif res == b's':
                    if Maze[now[0] + 1][now[1]] in " ？":
                        now[0] += 1
                        break
                elif res == b'a':
                    if Maze[now[0]][now[1] - 1] in " ？":
                        now[1] -= 1
                        break
                elif res == b'd':
                    if Maze[now[0]][now[1] + 1] in " ？":
                        now[1] += 1
                        break

def cycle_4(name):
    intro_2(24)

    system("cls")
    wait_for_enter()
    wait_for_enter("一年的实习过后，去年我终于转正了。")
    wait_for_enter("在律所看久了才知道，林鸥虽然是个小地方，闹出的幺蛾子可一点不少。")
    wait_for_enter("某种意义上，这对我来说是个好消息。")
    wait_for_enter("案源多了，我们才有生存的空间。")
    wait_for_enter("到24岁，我也快工作满一年了。")
    wait_for_enter("我们这的年薪比起鹰吕还有些差距，不过也足以养活家人了。")
    wait_for_enter("总体来说，去年的生活很平静，毕竟我的原则是不求有功但求无过。")
    wait_for_enter("去年，我们律所接到了一个IPO业务——非诉业务里收入最高的之一。")
    wait_for_enter("如果能争取一下，我说不定有能参与的机会。")
    wait_for_enter("但对我这种刚入行的新人，这还是太困难了。")
    wait_for_enter("于是，我继续过着平静的生活，直到现在。")

    for i in range(1,17):
        sleep(0.1)
        system("cls")
        print(("一年的实习过后，去年我终于转正了。" + " " * 15 + "今天的风很大。")[2*i:])
        print("在律所看久了才知道，林鸥虽然是个小地方，闹出的幺蛾子可一点不少。"[2*i:])
        print("某种意义上，这对我来说是个好消息。"[2*i:])
        print("案源多了，我们才有生存的空间。"[2*i:])
        print("到24岁，我也快工作满一年了。"[2*i:])
        print("我们这的年薪比起鹰吕还有些差距，不过也足以养活家人了。"[2*i:])
        print("总体来说，去年的生活很平静，毕竟我的原则是不求有功但求无过。"[2*i:])
        print("去年，我们律所接到了一个IPO业务——非诉业务里收入最高的之一。"[2*i:])
        print("如果能争取一下，我说不定有能参与的机会。"[2*i:])
        print("但对我这种刚入行的新人，这还是太困难了。"[2*i:])
        print("于是，我继续过着平静的生活，直到现在。"[2*i:])
    wait_for_enter()
    system("cls")
    wait_for_enter("今天的风很大。")
    wait_for_enter("我下班时，天已经完全黑了。")
    wait_for_enter("我边在河边散着步，边想着今天刚办的案子。")

    # Puzzle 5
    choice_4_1()

    # Puzzle 6
    choice_4_2()

    # Puzzle 7
    choice_4_3()

    # Puzzle 8
    choice_4_4()

    system("cls")
    wait_for_enter()
    wait_for_enter("今天的风很大。")
    wait_for_enter("我下班时，天已经完全黑了。")
    wait_for_enter("我边在河边散着步，边想着今天刚办的案子。")
    wait_for_enter("——不知道自己该回到哪去。")
    wait_for_enter("量表上抑郁已经达到了重度。")
    wait_for_enter("我这是怎么了？")
    wait_for_enter("是不是……")
    wait_for_enter("真的到必须做出改变的时刻了呢……")
    wait_for_enter(name + "？又是你吗？")
    wait_for_enter("这次你想说什么？")

    with open(OUT_PATH, "w") as f:
        f.write(name + "\n4\n")
    
    ret = input("[进度已保存] 输入0以退出，输入其他以继续：")
    return ret == "0", 4

def intro_5(age, name = "于寒"):
    system("cls")
    wait_for_enter(L + "\n  欢迎来到SCL-90测试程序！\n" + L)
    wait_for_enter("姓名：" + name)
    wait_for_enter("年龄：" + str(age))
    wait_for_enter("按回车开始测试。")
    system("cls")
    print(L)
    print("感谢您的配合，请阅读测试须知：")
    wait_for_enter("以下表格中列出了你的病痛或问题，请务必仔细阅读每一条。\n" + L)

def choice_5(num):
    now = 4
    while True:
        system("cls")
        l = len(C)
        print(Q + str(num + 1) + ". " + question_list[num])
        for i in range(l):
            if i == now:
                print("   -> ", end="")
            else:
                print("      ", end="")
            print(C[i])
        print(L)
        while True:
            sleep(0.03)
            if kbhit():
                res = getch()
                flush_in()
                if res == b's':
                    now = 4
                    break
                elif res == b'w':
                    now = 3
                    break
                elif res == b'\r':
                    return now

def choice_5_1():
    Maze = [
        "|你的25岁在茫然中度过。",
        "| 你想着求稳， 想着 不犯错。",
        "|  代价便是， 只要 犯了错，",
        "|选择就已不属于你。  "
    ]
    now = [1, 1]
    count = 0
    me = "<>"
    flag = False
    while True:
        system("cls")
        for i in range(len(Maze)):
            for j in range(len(Maze[i])):
                if Maze[i][j] != " ":
                    print(Maze[i][j], end = "")
                elif now[0] == i and now[1] == j:
                    print(me, end = "")
                else:
                    print("  ", end = "")
            print()
        count += 1
        if count == 3 and not flag: Maze.append("|谁都能看到取代你的机会。")
        if count == 10 and me == "<>": Maze[0] += "[利用“选择”去改变]"
        if flag:
            if count == 3: Maze.append("|而你又一次选择了     退让。")
            if count == 5: Maze.append("|像你之前每次   选择那样。")
            if count == 9: Maze.append("|你再次放 弃 了。")
            if count == 13: Maze.append("|怀疑越来 越多。")
            if count == 15: Maze.append("|大概，你 从无正确的决定，从不去鹰吕开始，直到现在。")
            if count == 16: Maze.append("|最初只是 轻度的自卑感，")
            if count == 17: Maze.append("|慢慢成为 中度抑郁，")
            if count == 18: Maze.append("|等到问题 偏重，你才开始后悔，但惯性的力量是无穷的。")
            if count == 19: Maze.append("|如今，已 严重幻听幻视的你，又能如何摆脱呢。")
            if count == 20: Maze.append("|该做出唯一的选择了。")
            if count == 25: Maze.append(" [按回车进行选择]")

        while True:
            sleep(0.03)
            if kbhit():
                res = getch()
                flush_in()
                if res == b'w':
                    if Maze[now[0] - 1][now[1]] in " ？":
                        now[0] -= 1
                        break
                elif res == b's':
                    if Maze[now[0] + 1][now[1]] in " ？":
                        now[0] += 1
                        break
                    if Maze[now[0] + 1][now[1]] in "选择":
                        me = "->"
                        break
                elif res == b'a':
                    if Maze[now[0]][now[1] - 1] in " ？" and me == "<>":
                        now[1] -= 1
                        break
                    elif me == "->":
                        now[1] = (now[1] + len(Maze[now[0]]) - 1) % len(Maze[now[0]])
                        while Maze[now[0]][now[1]] != " ":
                            now[1] = (now[1] + len(Maze[now[0]]) - 1) % len(Maze[now[0]])
                        break
                elif res == b'd':
                    if Maze[now[0]][now[1] + 1] in " ？" and me == "<>":
                        now[1] += 1
                        break
                    elif me == "->":
                        now[1] = (now[1] + 1) % len(Maze[now[0]])
                        while Maze[now[0]][now[1]] != " ":
                            now[1] = (now[1] + 1) % len(Maze[now[0]])
                        break
                elif res == b'\r':
                    if now[0] in range(10, 15):
                        return now[0] - 10
        if now[0] == 3 and now[1] == 11 and not flag:
            flag = True
            count = 0
            Maze[3] += "  于"
            Maze[4] += " 是"
            Maze.append("|你再也接不到能做出成绩的 案子了。")

def choice_5_2():
    qlist = [
        "26岁那年，律所里来了一位新的实习律师。",
        "他也是林鸥大学毕业的，不想走远，就找了个离家近的律所。",
        "或许是因为同校，<>他来到了你的手下。",
        "和你这个所里知名  的老油条相比，他还是稚嫩不少。",
        "他有时会在工作中  犯一些小错，  你则对他十分严格。",
        "他不敢质疑你的选择，脸上总有    近乎谄媚的笑意。",
        "怎么会有这么讨厌的人呢，      你时常如此想到。",
        "在长长的过道尽头，你看到一扇门。而他就站在你的对面。"
    ]
    c = ["上", "下", "左", "右"]
    answer = [1, 1, 1, 3, 1, 2, 1, 1]
    flag = True
    while flag:
        flag = False
        for i in range(len(qlist)):
            ans = choice(Q + "  " + qlist[i], c, L)
            if ans != answer[i]:
                flag = True
        if flag:
            system("cls")
            wait_for_enter("怎么，你还以为是随便选选吗？")
            wait_for_enter("最后一扇门就隐藏在这些题目里。")
            wait_for_enter("找到它，结束这一切吧。")
            ret = input("[输入 -1 获取提示，输入 -2 获取详细提示，输入其他继续]")
            if ret == -1:
                wait_for_enter("[注意“选择”和“门”]")
            elif ret == -2:
                wait_for_enter("[将这些问题从上到下可以排成迷宫]")

def cycle_5(name):
    intro_5(26)
    sleep(0.5)
    qlist = [6, 16, 28, 32, 53, 56, 70, 78, 85, 88]
    word = [
        "我没有什么可说的了。",
        "这是你自找的。",
        "你已经26岁了，还是混混噩噩。",
        "不，应该说比以前更甚。",
        "这真的只是因为一个选择吗？",
        "你也不知道吧。",
        "你还想听故事吗？",
        "自己的、可悲的故事？",
        "那，找到这里的门吧。",
        "只有焦虑与抑郁叠加，才能打开这扇门。"]
    
    code = ["FinalCode:", "9", "4", "5", "0", "9", "3", "0", "6", "3"]
    
    # Puzzle 9
    flag = True
    while flag:
        for i in range(10):
            choice_5(qlist[i])
            wait_for_enter(word[i])
            print(code[i])
            sleep(0.03)
        while True:
            system("cls")
            print(L + "\n    SCL-90 Results\n" + L)
            print("      总均分: 3.52")
            print("      躯体化: 中 (2.67)")
            print("      强迫症状: 重 (3.60)")
            print("      人际关系: 重 (3.78)")
            print("      抑郁: 重 (4.31)")
            print("      焦虑: 重 (4.00)")
            print("      敌对: 重 (3.50)")
            print("      恐惧: 中 (3.14)")
            print("      偏执: 中 (2.83)")
            print("      精神病性: 中 (3.30)")
            print("      其他: 重 (3.71)")
            ret = input(L + "\n请输入 0 重新测试，输入 1 结束测试：")
            if ret == '0':
                print("……")
                sleep(0.5)
                break
            elif ret == '1':
                wait_for_enter("再停留一会儿吧。")
                ret = input("这次的门，可是需要正确密码的：")
                if ret == "8.31":
                    flag = False
                    break
            elif ret == "-1":
                wait_for_enter("[答案藏在结果中]")
            elif ret == "-2":
                wait_for_enter("[计算焦虑与抑郁的和]")
            else:
                wait_for_enter("[输入 -1 获取提示，输入 -2 获取详细提示]")

    system("cls")
    wait_for_enter("又是两年过去了，我渐渐习惯了在律所的生活。")
    wait_for_enter("——谎言。")
    wait_for_enter("那次犯错之后，我消沉了挺长一段时间，不过还是回到了正轨。")
    wait_for_enter("——从没有。")
    wait_for_enter("至少，现在我是事务所最好的授薪律师了。")
    wait_for_enter("——自我安慰罢了。")
    wait_for_enter("别吵了！")
    wait_for_enter("——你已经能随时听到我的话了呢。")
    wait_for_enter("所以，" + name + "，你到底是不是我？")
    wait_for_enter("——谁知道呢。")
    
    system("cls")
    wait_for_enter("——既然你还在说谎，就由我来继续讲这个故事好了。")
    wait_for_enter("——没错，你确实在律所又干了两年，也成了最好的授薪律师。")
    wait_for_enter("——但众所周知，只有接不到案子的人才会做授薪律师。")
    wait_for_enter("——下面就来看看，这两年你又干了什么吧。")

    # Puzzle 10
    ans = choice_5_1()

    system("cls")
    wait_for_enter()
    wait_for_enter("——好吧，你选了" + C[ans] + "。")
    wait_for_enter("——不过这个选择也不那么重要。")
    wait_for_enter("——或许旁人看来，你也没遇到多大点事，对吧。")
    wait_for_enter("——可是，你就是这样一个人。")
    wait_for_enter("——你就是喜欢反复咀嚼自己的遗憾。")
    wait_for_enter("——那，又有什么办法呢？")
    wait_for_enter("——你还是迎来了26岁——也是我对你说话的第五年。")
    wait_for_enter("——下面，是最后一扇门了。")

    # Puzzle 11
    choice_5_2()

    system("cls")
    wait_for_enter()
    wait_for_enter("——你已经不出声了呢。")
    wait_for_enter("——只是这个程度，就承受不了了吗？")
    wait_for_enter("——靠着打击实习生来从过去的自己找优越感，还真是你会干出来的事。")
    wait_for_enter("——我早就说过，真相不像你预料中的那么美好。")
    wait_for_enter("——啊，好像到现在，还差一年的故事啊。")
    wait_for_enter("——不过我已经说厌了。")

    with open(OUT_PATH, "w") as f:
        f.write(name + "\n5\n")

    ret = input("[进度已保存] 输入0以退出，输入其他以继续：")
    return ret == "0", 5

def choice_f():
    now = 0
    pos = -1
    c = ["是", "否"]
    while True:
        system("cls")
        print("  27岁这年，对你来说其实乏善可陈。")
        print("  你已经学会了最重要的美德，")
        print("  麻木。")
        print("  跟着你的实习生最后不愿意留在你们律所，怎么看都是你的“功劳”。")
        print("  说着说着，又回到现在了呢。")
        print("  你一次次在幻境中填着无聊的量表，因为这代表你不幸的开始。")
        print("  可你也知道，无论是它，还是我，都不可能改变什么。")
        print("  但现实，可能对你来说还更绝望一些。")
        print("  所以，该进行最后的选择了。")
        print("  你还要继续将量表填下去吗？")
        for i in range(2):
            if pos < 0:
                if i == now:
                    print("   -> " + c[i])
                else:
                    print("      " + c[i])
            elif pos < 3:
                if i == now:
                    print("      " + c[i] + " " * pos * 6 + "->")
                else:
                    print("      " + c[i])
            else:
                if i == now:
                    print("      " + c[i] + " " * 18 + "->" + "开门")
                else:
                    print("      " + c[i])
        print("  [这个选择很重要]")
        while True:
            sleep(0.03)
            if kbhit():
                res = getch()
                flush_in()
                if res == b'w':
                    now = 0
                    break
                elif res == b's':
                    now = 1
                    break
                elif res == b'\r':
                    if pos == 3:
                        return -1
                    return now
                elif res == b'd':
                    if pos == -1:
                        pos = 0
                    else: pos = -1
                    break
                elif res == b'o':
                    if pos in [0, 1]:
                        pos += 1
                    else: pos = -1
                    break
                elif res == b'r':
                    if pos == 2:
                        pos = 3
                    else: pos = -1
                    break
                else:
                    pos = -1
                    break

def final_choice(name):
    intro_2(27)

    system("cls")
    wait_for_enter("  27岁这年，对你来说其实乏善可陈。")
    wait_for_enter("  你已经学会了最重要的美德，")
    wait_for_enter("  麻木。")
    wait_for_enter("  跟着你的实习生最后不愿意留在你们律所，怎么看都是你的“功劳”。")
    wait_for_enter("  说着说着，又回到现在了呢。")
    wait_for_enter("  你一次次在幻境中填着无聊的量表，因为这代表你不幸的开始。")
    wait_for_enter("  可你也知道，无论是它，还是我，都不可能改变什么。")
    wait_for_enter("  但现实，可能对你来说还更绝望一些。")
    wait_for_enter("  所以，该进行最后的选择了。")
    
    sleep(1)
    flush_in()

    # Puzzle 12
    ret = choice_f()

    if ret == 0:
        wait_for_enter("  那么，这次没有声音会打扰你了。")
        return False, 7
    
    if ret == 1:
        wait_for_enter("  那就带你看看现实吧。")
        return False, 6
    
    with open(OUT_PATH, "w") as f:
        f.write(name + "\n8\n")

    ret = input("[进度已保存] 输入0以退出，输入其他以继续：")
    return ret == "0", 8

def cycle_e(name):
    intro_5(28, name)

    system("cls")
    wait_for_enter()
    wait_for_enter("所以，这就是终局了。")
    wait_for_enter("哪怕这样了还想离开循环，还真是天真呢。")
    wait_for_enter("他早就已经经受不了这样的打击了。")
    wait_for_enter("也该轮到我出场了。")
    wait_for_enter("——大家好，虽然姑且在这里和大家说话，但我不是于寒。")
    wait_for_enter("我叫" + name + "。")
    wait_for_enter("……")
    wait_for_enter("——其实，他还有一次改变的机会的，就在最终选择的时候。")
    wait_for_enter("——如果能选择“第三个选项”的话。")
    wait_for_enter("——毕竟，门就在那里。")
    wait_for_enter("——第一步，应该向右才对。")
    wait_for_enter("[结局 被替换者 已达成]")
    wait_for_enter("[回到剧情分支点]")
    return False, 5

def cycle_r():
    intro_2(28)
    ans = [0] * 90
    sleep(0.5)
    for i in range(len(question_list)):
        ans[i] = choice(Q + str(i + 1) + ". " + question_list[i], C, L)
    F = [.0] * 10
    F[0] = ans[0] + ans[3] + ans[11] + ans[26] + ans[39] + ans[41]\
        + ans[47] + ans[48] + ans[51] + ans[52] + ans[55] + ans[57]
    F[1] = ans[2] + ans[8] + ans[9] + ans[27] + ans[37] + ans[44]\
        + ans[45] + ans[50] + ans[54] + ans[64]
    F[2] = ans[5] + ans[20] + ans[33] + ans[35] + ans[36] + ans[40]\
        + ans[60] + ans[68] + ans[72]
    F[3] = ans[4] + ans[13] + ans[14] + ans[19] + ans[21] + ans[25]\
        + ans[28] + ans[29] + ans[30] + ans[31] + ans[53] + ans[70]\
        + ans[78]
    F[4] = ans[1] + ans[16] + ans[22] + ans[32] + ans[38] + ans[56]\
        + ans[71] + ans[77] + ans[79] + ans[85]
    F[5] = ans[10] + ans[23] + ans[62] + ans[66] + ans[73] + ans[80]
    F[6] = ans[12] + ans[24] + ans[46] + ans[49] + ans[69] + ans[74]\
        + ans[81]
    F[7] = ans[7] + ans[17] + ans[42] + ans[67] + ans[75] + ans[82]
    F[8] = ans[6] + ans[15] + ans[34] + ans[61] + ans[76] + ans[83]\
        + ans[84] + ans[86] + ans[87] + ans[89]
    F[9] = ans[18] + ans[43] + ans[58] + ans[59] + ans[63] + ans[65]\
        +  ans[88]
    S = sum(F) / 90 + 1
    F[0] /= 12; F[1] /= 10; F[2] /= 9; F[3] /= 13; F[4] /= 10
    F[5] /= 6; F[6] /= 7; F[7] /= 6; F[8] /= 10; F[9] /= 7
    F[0] += 1; F[1] += 1; F[2] += 1; F[3] += 1; F[4] += 1
    F[5] += 1; F[6] += 1; F[7] += 1; F[8] += 1; F[9] += 1
    
    def to_str(num):
        if num >= 4.5:
            return "严重"
        if num >= 3.5:
            return "重"
        if num >= 2.5:
            return "中"
        if num >= 1.5:
            return "轻"
        return "无"
    
    while True:
        system("cls")
        print(L + "\n    SCL-90 Results\n" + L)
        print("      总均分: {:.2f}".format(S))
        print("      躯体化: {} ({:.2f})".format(to_str(F[0]), F[0]))
        print("      强迫症状: {} ({:.2f})".format(to_str(F[1]), F[1]))
        print("      人际关系: {} ({:.2f})".format(to_str(F[2]), F[2]))
        print("      抑郁: {} ({:.2f})".format(to_str(F[3]), F[3]))
        print("      焦虑: {} ({:.2f})".format(to_str(F[4]), F[4]))
        print("      敌对: {} ({:.2f})".format(to_str(F[5]), F[5]))
        print("      恐惧: {} ({:.2f})".format(to_str(F[6]), F[6]))
        print("      偏执: {} ({:.2f})".format(to_str(F[7]), F[7]))
        print("      精神病性: {} ({:.2f})".format(to_str(F[8]), F[8]))
        print("      其他: {} ({:.2f})".format(to_str(F[9]), F[9]))
        print(L)
        print("[结局 无限循环 已达成]")
        print("输入 0 重新测试，输入 1 结束测试，")
        ret = input("或输入 2 获取更多信息 [请谨慎选择]：")
        if ret == '0':
            wait_for_enter("好吧。")
            wait_for_enter("那么，再来一次。")
            return False, 7
        elif ret == '1':
            wait_for_enter("[回到剧情分支点]")
            return False, 5
        elif ret == '2':
            wait_for_enter("循环的过程中，我渐渐恢复了理智。")
            wait_for_enter("无论选择哪个选项，都是在那家伙的引导下选择罢了。")
            wait_for_enter("既然没有门，就应该创造出门。")
            wait_for_enter("[输入 -1 获取提示，输入 -2 获取详细提示]")
        elif ret == '-1':
            wait_for_enter("[在两个结局中寻找线索吧]")
        elif ret == '-2':
            wait_for_enter("[在最终选择时输入 door]")
        else:
            wait_for_enter("[输入 -1 获取提示，输入 -2 获取详细提示]")

def real_end(name):
    system("cls")
    wait_for_enter()
    wait_for_enter("请当事人，代理人入庭。")
    wait_for_enter("请审判长入庭。")
    wait_for_enter("于寒，你的灵魂被指控犯有以下七项罪名。")
    wait_for_enter("你有就案件事实进行陈述与申辩的权利。")
    qu = L + "\n    Final Court\n" + L + "\n "
    qlist = [
        "其之一，当它可以升迁时，却选择谦让。",
        "其之二，当它在腿残者前跛足而行。",
        "其之三，当它在难易之间选择容易。",
        "其之四，当它犯了错误，却用别人也会犯类似的错为借口。",
        "其之五，当它因脆弱而忍让，却说成是一种坚忍。",
        "其之六，当它鄙夷一张丑恶的面庞，殊不知这正是自己的一副面具。",
        "其之七，当它吟唱颂歌却自以为是一种美德。"
    ]
    ans = choice(qu + qlist[0], ["无异议", "异议"], L)
    if ans == 0:
        wait_for_enter("看来你没什么想反驳的。")
        wait_for_enter("那就下一个吧。")
    else:
        wait_for_enter("被告方举证，21岁时，鹰吕的录取通知与最终选择的林鸥律所。")
        wait_for_enter("驳回原告方异议。")
    sleep(0.3)
    ans = choice(qu + qlist[1], ["无异议", "异议"], L)
    if ans == 0:
        wait_for_enter("哦？这个也不准备反驳吗？")
        wait_for_enter("挺好。")
    else:
        wait_for_enter("被告方举证，22岁时，和朋友嘲笑陈目的电话录音。")
        wait_for_enter("驳回原告方异议。")
    sleep(0.3)
    ans = choice(qu + qlist[2], ["无异议", "异议"], L)
    if ans == 0:
        wait_for_enter("你每次都会做出这样的选择，不是吗？")
        wait_for_enter("看来这条确实无可置疑。")
    else:
        wait_for_enter("被告方举证，23岁时，和合伙人关于放弃争取IPO项目的对话。")
        wait_for_enter("驳回原告方异议。")
    sleep(0.3)
    ans = choice(qu + qlist[3], ["无异议", "异议"], L)
    if ans == 0:
        wait_for_enter("希望你还对此印象深刻。")
        wait_for_enter("——毕竟，是你自己的错误。")
    else:
        wait_for_enter("被告方举证，24岁时，由律所承担80%损失的判决书。")
        wait_for_enter("驳回原告方异议。")
    sleep(0.3)
    ans = choice(qu + qlist[4], ["无异议", "异议"], L)
    if ans == 0:
        wait_for_enter("继续吧。")
        wait_for_enter("快结束了。")
    else:
        wait_for_enter("被告方举证，25岁时，甘愿成为授薪律师的协议。")
        wait_for_enter("驳回原告方异议。")
    sleep(0.3)
    ans = choice(qu + qlist[5], ["无异议", "异议"], L)
    if ans == 0:
        wait_for_enter("你知道这说的是谁，对吧。")
        wait_for_enter("……")
    else:
        wait_for_enter("被告方举证，26岁时，和手下实习律师签订的严苛约定。")
        wait_for_enter("驳回原告方异议。")
    sleep(0.3)
    ans = choice(qu + qlist[6], ["无异议", "异议"], L)
    if ans == 0:
        wait_for_enter("那么，这是最后一个了。")
        wait_for_enter("既然无异议，就可以判决了哦。")
        system("cls")
        wait_for_enter()
        wait_for_enter("经当事人当庭辩论后，本案判决如下：")
        wait_for_enter("——被告，于寒，其灵魂犯有七重罪行，罪无可恕。")
        wait_for_enter("判处终身监禁，立即执行。")
        wait_for_enter("……")
        print("[结局 永无宁日 已达成]")
        wait_for_enter("[回到本段开头]")
        return False, 8
    wait_for_enter("……")
    system("cls")
    wait_for_enter("恭喜你，抓住了最后的漏洞。")
    wait_for_enter("反驳有效，罪名不成立。")
    wait_for_enter("但那又怎样呢？")
    wait_for_enter("你还有整整六项罪名呢。")
    wait_for_enter("难道你真的觉得自己可以洗脱不存在的冤屈吗？")
    system("cls")
    wait_for_enter("——当然不能。")
    wait_for_enter("哦？")
    wait_for_enter("——但我至少知道了你是个什么玩意。")
    wait_for_enter("我是什么？")
    wait_for_enter("——你不是我。")
    wait_for_enter("所以呢？")
    wait_for_enter("——你恐怕就是量表本身吧，或者说，诞生于量表中的意识。")
    wait_for_enter("……")
    wait_for_enter("——是陈目。")
    wait_for_enter("怎么，到现在想把锅推给不在场的人了？")
    wait_for_enter("——这本来就是陈目的阴谋而已。")
    system("cls")
    wait_for_enter()
    wait_for_enter("一切，都以我得到那个量表为起点。")
    wait_for_enter("心理学上有种有趣的现象，叫“医学生综合征”。")
    wait_for_enter("具体表现为，医学生每学到一种病就怀疑自己或亲友有这种病。")
    wait_for_enter("哪怕只是重复填写量表本身，都会让人对症状更加确信。")
    wait_for_enter("而陈目所做的，显然不止于此。")
    wait_for_enter("这个声音就是他的杰作。")
    wait_for_enter("至于他是怎么做到的，已经不重要了。")
    wait_for_enter("但我确实在" + name + "的引导中，犯下了他所设计的一切罪行。")
    wait_for_enter("年复一年。")
    wait_for_enter("这并不是借口，而是，唯一的可能。")
    wait_for_enter("但他的最后一步计划没有成功。")
    wait_for_enter("对应于27岁的事件，并没有发生。")
    wait_for_enter("难道是巧合吗……")
    wait_for_enter("无论如何，现在该做的是……")
    system("cls")
    wait_for_enter("——醒醒！")
    wait_for_enter("——我叫申屿，你可以喊我申医生。")
    wait_for_enter("——你的催眠治疗已经结束了。")
    wait_for_enter("——最近这样奇怪的情况还真多啊，似乎是某种能力引导的结果。")
    wait_for_enter("——如果再不抓住真凶的话，情况可能会……")
    wait_for_enter("……")
    wait_for_enter("我可能知道是谁干的。")
    sleep(0.8)
    while True:
        system("cls")
        print("[结局 开端的结束 已达成]")
        print("输入 0 重新体验本段，输入 1 重置并退出")
        ret = input("——或者输入其他？\n")
        if ret == "0":
            return False, 8
        elif ret == "1":
            with open(OUT_PATH, "w") as f:
                f.write("\n\n")
            return True, 0
        elif ret == "945093063":
            return False, 9
        else:
            wait_for_enter("[之前的故事中藏着密码]")

def after():
    system("cls")
    wait_for_enter()
    wait_for_enter("于寒：")
    wait_for_enter("    生日快乐！")
    wait_for_enter("    21岁，大概是个不错的时间。")
    wait_for_enter("    可我并不喜欢王小波，也不觉得这是一生的某个黄金时代。")
    wait_for_enter("    时间仓促，我也来不及准备什么礼物，就写下这么一个故事送给你吧。")
    wait_for_enter("    ——不得不说，我很喜欢这种自己在幕后当boss的感觉。")
    wait_for_enter("    至于申屿，反正那家伙确实读的心理，让他来出个场也挺好。")
    wait_for_enter("    说不定之后能把这故事做成一个系列，讲一个有异能的咨询师的故事。")
    wait_for_enter("    这系列就叫 Dr.S 好了。")
    wait_for_enter("    ——我知道你想吐槽什么：哪有生日送的故事把人写得这么不堪的！")
    wait_for_enter("    嘛，这些事不都还没发生嘛。")
    wait_for_enter("    而且在无限循环里写着量表这个设定真的很酷欸！")
    wait_for_enter("    哦对了，那个七重罪行其实是最近读到的一首诗：")
    wait_for_enter("    纪伯伦的《我曾七次鄙视自己的灵魂》。")
    wait_for_enter("    整个故事的架构都是从这首诗上延伸出来的。")
    wait_for_enter("    明明都是人之常情，却也能击垮一个人呢。")
    wait_for_enter("    好像想说的就这些了。")
    wait_for_enter("    那最后，就祝你带着炽热的灵魂活下去吧。")
    wait_for_enter("    祝你永远无需为它辩护。")
    wait_for_enter("                                                    陈目, 8.17凌晨")
    sleep(0.5)
    wait_for_enter("[按回车重置进度并退出]")
    with open(OUT_PATH, "w") as f:
        f.write("\n\n")
    return True, 0